/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef X11WINDOW_H
#define X11WINDOW_H

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <GL/glew.h>
#include <GL/gl.h>
#include <GL/glx.h>

#include "BaseWindow.h"

namespace Engine {
namespace Platform {

class X11Window;

class X11RenderContext : public RenderContextInterface
{
    public:
        X11RenderContext(X11Window *window);
        virtual ~X11RenderContext();

        virtual void makeCurrent();
        virtual void swap();
    private:
        X11Window *m_window;
        GLXContext m_context;

        friend class X11Window;
};


class X11Window : public BaseWindow
{
    public:
        X11Window();
        virtual ~X11Window();

        virtual void resetWindow(WindowParams &params);
        virtual bool getNextEvent(Event &event);

    protected:
        Display *m_display;
        const char *m_glxExtensionString;
        Window m_window;
        Colormap m_colormap;

        void createWindow();
        void freeWindow();

        void openDisplay();
        void closeDisplay();

        X11RenderContext *context() { return (X11RenderContext*) m_renderContext; }

        void makeCurrent();
        void swap();
        friend class X11RenderContext;
    private:
};

}
}

#endif // X11WINDOW_H
