/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef CAMERA_H
#define CAMERA_H

#include "../tools/LinAlg.h"
#include "BundleAdjustment/BundleAdjustment.h"

namespace SFM {

class InternalCameraCalibration;

/**
 * @brief Holds all the camera related information like the view matrix for the structur from motion pipeline.
 * @ingroup SFMBackend_Group
 */
class Camera
{
    public:
        Camera(InternalCameraCalibration *internalCalibration);
        ~Camera();

        void setViewMatrix(const LinAlg::Matrix4x4f &viewMatrix);
        void onInternalCameraCalibrationChanged();

        inline const LinAlg::Matrix4x4f &getInvProjectionViewMatrix() const { return m_invProjectionViewMatrix; }
        inline const LinAlg::Matrix4x4f &getProjectionViewMatrix() const { return m_projectionViewMatrix; }
        inline const LinAlg::Matrix3x4f &getProjectionViewMatrix3x4() const { return m_projectionViewMatrix3x4; }
        inline const LinAlg::Matrix4x4f &getViewMatrix() const { return m_viewMatrix; }
        inline const LinAlg::Vector3f &getCameraPosition() const { return m_cameraPosition; }

        InternalCameraCalibration *getInternalCalibration() const { return m_internalCalibration; }

        inline BundleAdjustment::CameraHandle getBAHandle() const { return m_baCameraHandle; }


        void activateBA(BundleAdjustment &ba);
        void updateBA(BundleAdjustment &ba);
        void readBackFromBA(BundleAdjustment &ba);

        bool activeInBA() const { return m_baCameraHandle!=(unsigned)-1; }
    protected:
        InternalCameraCalibration *m_internalCalibration;

        LinAlg::Matrix4x4f m_invProjectionViewMatrix;
        LinAlg::Matrix4x4f m_projectionViewMatrix;
        LinAlg::Matrix3x4f m_projectionViewMatrix3x4;
        LinAlg::Matrix4x4f m_viewMatrix;

        LinAlg::Vector3f m_cameraPosition;

        BundleAdjustment::CameraHandle m_baCameraHandle;
        BundleAdjustment *m_ba = nullptr;
};

}

#endif // CAMERA_H
