/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef TrackMatchingDescriptor_H
#define TrackMatchingDescriptor_H

#include "../tools/LinAlg.h"
#include "SiftDescriptorDB.h"

namespace SFM {

/**
 * @brief Set of feature descriptors that belong to a track.
 * @details These are used to find new observations of a track or to
 * add new cameras to the reconstruction. The set of feature descriptors is
 * usually a subset of the feature descriptors of all observations of the track.
 * @ingroup SFMBackend_Group
 */
class TrackMatchingDescriptor
{
    public:
        TrackMatchingDescriptor();
        ~TrackMatchingDescriptor();
#if 0
        void updatePreWarpedDescriptor(const uint32_t *data);

        PatchDescriptorDB::PatchDescriptor *getDescriptors() { return m_descriptors; }
    protected:
        PatchDescriptorDB::PatchDescriptor m_descriptors[11];
        LinAlg::Vector2f m_anchors[11];
#else
        void clear() { m_descriptors.clear(); m_viewDirections.clear(); }
        void addDescriptor(const SiftDescriptorDB::SiftDescriptor &descr, const LinAlg::Vector3f &viewDirection);

        inline const std::vector<SiftDescriptorDB::SiftDescriptor> &getDescriptors() const { return m_descriptors; }
        inline const std::vector<LinAlg::Vector3f> &getViewDirections() const { return m_viewDirections; }

    protected:
        std::vector<SiftDescriptorDB::SiftDescriptor> m_descriptors;
        std::vector<LinAlg::Vector3f> m_viewDirections;
#endif
};

}

#endif // TrackMatchingDescriptor_H
