/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "CudaTextureReference.h"
#include "CudaDriver.h"

#include "CudaTextureMemory.h"

namespace CudaUtils {


CudaTextureReference::CudaTextureReference(CUtexref handle) : m_handle(handle)
{
    //ctor
}

CudaTextureReference::~CudaTextureReference()
{
    //dtor
}


void CudaTextureReference::setTexelFilterMode(FilterMode filterMode)
{
    CudaDriver::throwOnCudaError(cuTexRefSetFilterMode(m_handle, (CUfilter_mode)filterMode), __FILE__, __LINE__);
}

void CudaTextureReference::setMipmapFilterMode(FilterMode filterMode)
{
    CudaDriver::throwOnCudaError(cuTexRefSetMipmapFilterMode(m_handle, (CUfilter_mode)filterMode), __FILE__, __LINE__);
}

void CudaTextureReference::setMinMaxMipLevel(float minMipLevel, float maxMipLevel)
{
    CudaDriver::throwOnCudaError(cuTexRefSetMipmapLevelClamp(m_handle, minMipLevel, maxMipLevel), __FILE__, __LINE__);
}


void CudaTextureReference::setCoordinateNormalization(bool normalize)
{
    unsigned flags;
    CudaDriver::throwOnCudaError(cuTexRefGetFlags(&flags, m_handle), __FILE__, __LINE__);

    if (normalize)
        flags |= CU_TRSF_NORMALIZED_COORDINATES;
    else
        flags &= ~CU_TRSF_NORMALIZED_COORDINATES;

    CudaDriver::throwOnCudaError(cuTexRefSetFlags(m_handle, flags), __FILE__, __LINE__);
}


void CudaTextureReference::bindTexture(BaseCudaTextureMemory *texMemory)
{
    CudaDriver::throwOnCudaError(cuTexRefSetArray(m_handle, texMemory->getHandle(), CU_TRSA_OVERRIDE_FORMAT), __FILE__, __LINE__);
}

void CudaTextureReference::bindMipmappedTexture(CudaMipmappedTexture *texMemory)
{
    CudaDriver::throwOnCudaError(cuTexRefSetMipmappedArray(m_handle, texMemory->getHandle(), CU_TRSA_OVERRIDE_FORMAT), __FILE__, __LINE__);
}



}
