/*
    Structure from Motion with Deferred Feature Matching and Subset Bundle Adjustment
    Copyright (C) 2015 Andreas Ley <andy-ley@arcor.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/**
 * @file
 * @author Andreas Ley
 */
#include "SpectatorCamera.h"

SpectatorCamera::SpectatorCamera()
{
    m_rotation = Quaternion<float>(0.0f, 0.0f, 1.0f, 0.0f);
}

SpectatorCamera::~SpectatorCamera()
{
    //dtor
}

void SpectatorCamera::turn(float dx, float dy, float dz)
{
    m_rotation = Quaternion<float>::fromAxisAngle(dx, 1.0f, 0.0f, 0.0f)
                * Quaternion<float>::fromAxisAngle(dy, 0.0f, 1.0f, 0.0f)
                * Quaternion<float>::fromAxisAngle(dz, 0.0f, 0.0f, 1.0f)
                * m_rotation;

    m_rotation = m_rotation.normalized();
}

void SpectatorCamera::accelerate(const LinAlg::Vector3f &eyeSpaceAcceleration, float dt)
{
    m_speed += (m_eyeToWorldSpace * eyeSpaceAcceleration.AddHom(0.0f)).StripHom() * dt;
}

void SpectatorCamera::operate(float dt)
{
    m_position += m_speed * dt;
    m_speed *= powf(0.2f, dt);
}

void SpectatorCamera::updateMatrices()
{
    m_rotation = m_rotation.normalized();
    LinAlg::Matrix3x3f rot = m_rotation.versorToRotationMatrix();

    LinAlg::Matrix4x4f rot4x4;
    rot4x4[0] = rot[0].AddHom(0.0f);
    rot4x4[1] = rot[1].AddHom(0.0f);
    rot4x4[2] = rot[2].AddHom(0.0f);

    m_worldToEyeSpace = rot4x4 * LinAlg::Translation3D(m_position.negated());
    m_eyeToWorldSpace = LinAlg::Translation3D(m_position) * rot4x4.T();
}
